Create Function
	[dbo].[Fn_RecItems_GetItemsGroupBy]
(
--Declare
		@ReceptionId BigInt = 6330
)
Returns Table
Return
Select
		Stuff
			(
				(
					Select ',' + Cast(ii.[mUserCode] As Varchar)
					From
					(
						Select
							--Distinct 
								ii.[mUserCode]
						From [dbo].[tblRecItems] As ss
						Left Join [dbo].[tblItems] As ii On ii.[mNumber] = ss.[mTestID]
						Where ss.[mSickNo] = @ReceptionId
						  And IsNull(ss.[mSickLinkNo],0) = 0
						  And ii.[mIntCode] = i.[mIntCode]
						  And ss.[mPrice] = s.[mPrice]
					) As ii
					For XML Path(''), Type
				).value('.','Varchar(Max)'), 1, 1, ''
			) As Code,
		i.[mIntCode],
		Stuff
			(
				(
					Select ',' + ii.[mFullName] + ' ('+ ii.[mShortName] +')'
					From
					(
						Select 
								Distinct
										ii.[mFullName],
										ii.[mShortName]
						From [dbo].[tblRecItems] As ss
						Left Join [dbo].[tblItems] As ii On ii.[mNumber] = ss.[mTestID]
						Where ss.[mSickNo] = @ReceptionId
						  And IsNull(ss.[mSickLinkNo],0) = 0
						  And ii.[mIntCode] = i.[mIntCode]
						  And ss.[mPrice] = s.[mPrice]
					) As ii
					For XML Path(''), Type
				).value('.','Varchar(Max)'), 1, 1, ''
			) As [Name],
		Sum(s.[mTPrice]) tPrice,
		Sum(s.[mFPrice]) aPrice,
		Count(*) + Sum(IsNull(i.[mInsureRepeat],0) - 1) CountTest,
		s.[mPrice]
	From [dbo].[tblRecItems] As s
	Left Join [dbo].[tblItems] As i On i.[mNumber] = s.[mTestID]
	Where	s.[mSickNo] = @ReceptionId
	And		IsNull(s.[mSickLinkNo],0) = 0
	Group By 
			i.[mIntCode],
			s.[mPrice]
