Create Function
	[dbo].[Fn_Insures2_GetTable]
()
Returns Table
Return
Select
		s.[mID],
		s.[mName],
		s.[mFranshizPercent],
		s.[mDiffPricePercent],
		s.[mPayablePercent],
		s.[mMaxPayment],
		s.[mKID],
		s.[mInsureDependency],
		s.[mFranshiz4AzadTest],
		s.[RasaId],
		d.[mKDate],
		d.[mKProf],
		d.[mKTech],
		r.[InsuranceCode],
		r.[InsuranceName],
        Case
			When d.[mKDate] Is Not Null Then d.[mKDate] + ' ( K حرفه ای: ' + [dbo].[Format](d.[mKProf],0) + ' ) ( K فنی: ' + [dbo].[Format](d.[mKTech],0) + ' )' 
			Else 'مبنایی تعریف نشده است'
		End + 
        Case
	        When IsNull(s.[mInsureDependency],0) = 1 Then ' (عدم پوشش تست‌های آزاد)'
	        Else ' (پوشش تست‌های آزاد)'
        End +
        Case
	        When IsNull(s.[mFranshiz4AzadTest] ,0) = 1 Then ' (فرانشیز فقط برای تست‌های آزاد)'
	        Else ''
        End +
        Case
	        When IsNull(r.[InsuranceName] ,'') <> '' Then ' (معادل رسا:' + r.[InsuranceName] + ')'
	        Else ''
        End Info
	From [dbo].[tblInsures2] As s
	Left Join [dbo].[tblInsure2KDate] As d On d.[mInsure2ID] = s.[mID] And d.[mID] = s.[mKID]
	Left Join [dbo].[Rasa_InsuranceLists] As r On r.[Id] = s.[RasaId]
