Create Procedure
	[dbo].[Pr_Options_UpdateNameAndValue]
(
		@mNameOld Varchar(50),
		@mNameNew Varchar(50),
		@mValue Varchar(4000),
		@mComment Varchar(1500)
)
As
Declare
		@mID bigint
Select
		@mID = s.[mID]
	From [dbo].[tblOptions] As s
	Where	s.[mName] Like @mNameOld

If @mID Is Null
Begin
	Select
			@mID = s.[mID]
		From [dbo].[tblOptions] As s
		Where	s.[mName] Like @mNameNew
End


If @mID Is Null
	Begin
		Insert Into
			[dbo].[tblOptions]
					(
					[mName],
					[mValue],
					[mComment],
					[mUser]
					)
			Values
					(
					@mNameNew,
					@mValue,
					@mComment,
					''
					)
	End
Else
	Begin
		Update
			[dbo].[tblOptions]
				Set
					[mName] = @mNameNew,
					[mValue] = Case When @mValue Is Null Then [mValue] Else @mValue End,
					[mComment] = @mComment
			Where	[mID] = @mID
	End