Create Procedure
	[dbo].[Pr_Reception_GetHistoryColumn]
(
--Declare
	@IdNumber BigInt --= 2841743
)
As
Declare
		@DateReceptionTag Varchar(15),
		@TimeReceptionTag Varchar(10)
Select
		@DateReceptionTag = s.[mDate],
		@TimeReceptionTag = s.[mTime]
	From [dbo].[tblReception] As s
	Where	s.[mNumber] = @IdNumber

Declare @TbTmp Table
					(
					[mTestID] Bigint,
					[mHistory] Varchar(1000)
					)

Insert Into @TbTmp
Select
		s.[mTestID],
		s.[mResponse]
	From [dbo].[Fn_Reception_GetHistoryGraph](@IdNumber,0,4,0,0,0,0) As s
	Where	Case
				When s.[mDate] = @DateReceptionTag Then s.[mTime]
				Else '00:00'
			End < @TimeReceptionTag
	Order by s.[mDate] Desc, s.[mTime] Desc

;
With Dt1 As
(
	Select
			Distinct s.[mTestID]
		From @TbTmp As s
)
Select
		ss.[mTestID],
		SUBSTRING(c.[mHistory],1 ,Len(c.[mHistory]) - 2) [mHistory]
	From Dt1 As ss
	Cross Apply
				(
					Select 
						(
							Select
									--s.[mHistory] + ' / '
									Replace(s.[mHistory], Char(30),'') + ' / '
								From @TbTmp As s
								Where s.[mTestID] = ss.[mTestID]
								For Xml Path(''), TYPE
						).value('.', 'NVARCHAR(MAX)')		
				) c (mHistory)
	Order by [mTestID]