Alter
 Trigger 
[dbo].[Tr_Reception_UserTraceAndLabCashes]
	On [dbo].[tblReception]
	After Insert, Update, Delete
As

Set noCount On;

Declare
		@UserAction Varchar(50),
		@DateReg Varchar(50) = [dbo].[Fn_GetPersianDateStr](Null,'/') ,
		@TimeReg Varchar(50) = [dbo].[Fn_GetPersianTimeStr](':',2)

Set @UserAction = [dbo].[Fn_Options_GetCurrentUser]()


----------- Check Insert, Update, Deleted -----------------------------------------
Declare
		@CountInsert Bit = 0,
		@CountDelete Bit = 0,
		@RunAction TinyInt = 0 ---- Insert ==> Insert --- Update ==> 2 --- Delete ==> 3

Select @CountInsert = 
		Cast
			(
				Case
					When Count(*) = 0 Then 0
					Else 1
				End
			 As Bit)
	From Inserted As s

Select @CountDelete = 
		Cast
			(
				Case
					When Count(*) = 0 Then 0
					Else 1
				End
			 As Bit)
	From Deleted As s

IF @CountInsert = 1 And @CountDelete = 0 ------ Insert
Begin
	Set @RunAction = 1
End

IF @CountInsert = 1 And @CountDelete = 1 ------ Update
Begin
	Set @RunAction = 2
End

IF @CountInsert = 0 And @CountDelete = 1 ------ Delete
Begin
	Set @RunAction = 3
End

----------- End Check Insert, Update, Deleted -----------------------------------------





---------------- Action's ----------------------------------------
----------------------------- Start Insert -----------------------
IF @RunAction = 1 
Begin


Insert Into
	[dbo].[tblLabCashes]
			(
			[mUser],
			[mType],
			[mDate],
			[mTime],
			[mOldCash],
			[mDiffCash],
			[mNewCash],
			[mRegNo]
			)
	Select
			@UserAction,
			'پذيرش',
			@DateReg,
			@TimeReg,
			[dbo].[Fn_LabCashes_LastCash](),
			0,
			[dbo].[Fn_LabCashes_LastCash](),
			i.[mNumber]
		From Inserted As i
						
		
End
----------------------------- End Insert -----------------------
------------------------------- Start Delete -----------------------
--IF @RunAction = 3

--Begin
------------------------------- End Delete -----------------------
----------------------------- Start Update -----------------------

------------ Start tblLabCashes -------------------------
IF @RunAction = 2
Begin


	If Update([mCreditCard_Price])
	Begin
		Insert Into
			[dbo].[tblLabCashes]
					(
					[mUser],
					[mType],
					[mDate],
					[mTime],
					[mOldCash],
					[mDiffCash],
					[mNewCash],
					[mRegNo]
					)
			Select
					@UserAction,
					'اصلاح پرداخت کارتي',
					@DateReg,
					@TimeReg,
					[dbo].[Fn_LabCashes_LastCash](), --[mOldCash]
					IsNull(i.[mCreditCard_Price],0) - IsNull(d.[mCreditCard_Price],0), --[mDiffCash]
					[dbo].[Fn_LabCashes_LastCash]() + (IsNull(i.[mCreditCard_Price],0) - IsNull(d.[mCreditCard_Price],0)), --[mNewCash]
					i.[mNumber]
				From Inserted As i
				Left Join Deleted As d On d.[mNumber] = i.[mNumber]
				Where IsNull(i.[mCreditCard_Price],0) <> IsNull(d.[mCreditCard_Price],0)
	End
	
	If Update([msickPayment])
	Begin
		Insert Into
			[dbo].[tblLabCashes]
					(
					[mUser],
					[mType],
					[mDate],
					[mTime],
					[mOldCash],
					[mDiffCash],
					[mNewCash],
					[mRegNo]
					)
			Select 
					@UserAction,
					'اصلاح پرداختي',
					@DateReg,
					@TimeReg,
					[dbo].[Fn_LabCashes_LastCash](), --[mOldCash]
					i.[msickPayment] - d.[msickPayment], --[mDiffCash]
					[dbo].[Fn_LabCashes_LastCash]() + (IsNull(i.[msickPayment],0) - IsNull(d.[msickPayment],0)), --[mNewCash]
					i.[mNumber]
				From Inserted As i
				Left Join Deleted As d On d.[mNumber] = i.[mNumber]
				Where IsNull(i.[msickPayment],0) <> IsNull(d.[msickPayment],0)
	End

	If Update([mDiscount])
	Begin
		Insert Into
			[dbo].[tblLabCashes]
					(
					[mUser],
					[mType],
					[mDate],
					[mTime],
					[mOldCash],
					[mDiffCash],
					[mNewCash],
					[mRegNo]
					)
			Select
					@UserAction,
					'اصلاح تخفيف',
					@DateReg,
					@TimeReg,
					[dbo].[Fn_LabCashes_LastCash](), --[mOldCash]
					i.[mDiscount] - d.[mDiscount], --[mDiffCash]
					[dbo].[Fn_LabCashes_LastCash](), --(Case When c.[mNewCash] <> 1 Then 0	Else c.[mNewCash] End) + (i.[mDiscount] - d.[mDiscount]), --[mNewCash]
					i.[mNumber]
				From Inserted As i
				Left Join Deleted As d On d.[mNumber] = i.[mNumber]
				Where IsNull(i.[mDiscount],0) <> IsNull(d.[mDiscount],0)
	End
	
	If Update([mExtraMoney])
	Begin
		Insert Into
			[dbo].[tblLabCashes]
					(
					[mUser],
					[mType],
					[mDate],
					[mTime],
					[mOldCash],
					[mDiffCash],
					[mNewCash],
					[mRegNo]
					)
			Select 
					@UserAction,
					'اصلاح مبلغ اضافي',
					@DateReg,
					@TimeReg,
					[dbo].[Fn_LabCashes_LastCash](), --[mOldCash]
					i.[mExtraMoney] - d.[mExtraMoney], --[mDiffCash]
					[dbo].[Fn_LabCashes_LastCash](),--(Case When c.[mNewCash] <> 1 Then 0	Else c.[mNewCash] End) + (i.[mExtraMoney] - d.[mExtraMoney]), --[mNewCash]
					i.[mNumber]
				From Inserted As i
				Left Join Deleted As d On d.[mNumber] = i.[mNumber]
				Where IsNull(i.[mExtraMoney],0) <> IsNull(d.[mExtraMoney],0)
	End
------------ End tblLabCashes -------------------------

	If Update([mNoPrint])
	Begin
		Update
			[dbo].[tblReception]
				Set
					[mPrintUser] = @UserAction,
					[mFaRespPrintdate] = @DateReg,
					[mRespPrintTime] = @TimeReg
			From Inserted As i
			Where	[dbo].[tblReception].[mNumber] = i.[mNumber]

		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg,'تغيير تاريخ چاپ جواب ',d.[mFaRespPrintdate] + '-' + d.[mRespPrintTime], @DateReg + '-' + @TimeReg, i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	(IsNull(@DateReg,'') <> IsNull(d.[mFaRespPrintdate],'') Or IsNull(@TimeReg,'') <> IsNull(d.[mRespPrintTime],''))


	End;

--------------------------------
If Update([mDate])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير تاريخ پذيرش',d.[mDate],i.[mDate], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mDate],'') <> IsNull(d.[mDate],'')
	End

--------------------------------
If Update([mFName])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير نام کوچک',d.[mFName],i.[mFName], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mFName],'') <> IsNull(d.[mFName],'')
	End

--------------------------------
If Update([mLName])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير فاميل',d.[mLName],i.[mLName], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mLName],'') <> IsNull(d.[mLName],'')
	End

--------------------------------
If Update([mInsureCode])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير بيمه',d.[mInsureCode],i.[mInsureCode], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mInsureCode],-1) <> IsNull(d.[mInsureCode],-1)
	End

--------------------------------
If Update([mSentFromNo])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير ارسالي',d.[mSentFromNo],i.[mSentFromNo], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mSentFromNo],-1) <> IsNull(d.[mSentFromNo],-1)
	End

--------------------------------
If Update([mInsure2Code])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير بيمه تکميلي',d.[mInsure2Code],i.[mInsure2Code], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mInsure2Code],-1) <> IsNull(d.[mInsure2Code],-1)
	End

--------------------------------
If Update([mInsureSheetDate])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير تاريخ اعتبار',d.[mInsureSheetDate],i.[mInsureSheetDate], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mInsureSheetDate],'') <> IsNull(d.[mInsureSheetDate],'')
	End

--------------------------------
If Update([mInsureSheetNo])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير شماره دفترچه',d.[mInsureSheetNo],i.[mInsureSheetNo], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mInsureSheetNo],'') <> IsNull(d.[mInsureSheetNo],'')
	End

--------------------------------
If Update([mGender])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير جنسيت',d.[mGender],i.[mGender], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mGender],'') <> IsNull(d.[mGender],'')
	End

--------------------------------
If Update([mAge])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير سن',d.[mAge],i.[mAge], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mAge],-1) <> IsNull(d.[mAge],-1)
	End

--------------------------------
If Update([mAgeUnit])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير واحد سن',d.[mAgeUnit],i.[mAgeUnit], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mAgeUnit],'') <> IsNull(d.[mAgeUnit],'')
	End

--------------------------------
If Update([mDoctorNo])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير پزشک',d.[mDoctorNo],i.[mDoctorNo], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mDoctorNo],-1) <> IsNull(d.[mDoctorNo],-1)
	End

--------------------------------
If Update([mResponseDate])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير تاريخ جوابدهي',d.[mResponseDate],i.[mResponseDate], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mResponseDate],'') <> IsNull(d.[mResponseDate],'')
	End

--------------------------------
If Update([mTel])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير تلفن ',d.[mTel],i.[mTel], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mTel],'') <> IsNull(d.[mTel],'')
	End

--------------------------------
If Update([mPrescriptionDate])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير تاريخ نسخه ',d.[mPrescriptionDate],i.[mPrescriptionDate], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mPrescriptionDate],'') <> IsNull(d.[mPrescriptionDate],'')
	End

--------------------------------
If Update([mClinicalData])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير توضيحات پذيرش ',d.[mClinicalData],i.[mClinicalData], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mClinicalData],'') <> IsNull(d.[mClinicalData],'')
	End

--------------------------------
If Update([mCanceled])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت ابطال ',d.[mCanceled],i.[mCanceled], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mCanceled],0) <> IsNull(d.[mCanceled],0)
	End

--------------------------------
If Update([mAddress])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير آدرس ',d.[mAddress],i.[mAddress], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mAddress],'') <> IsNull(d.[mAddress],'')
	End

--------------------------------
If Update([mMobile])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير موبايل ',d.[mMobile],i.[mMobile], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mMobile],'') <> IsNull(d.[mMobile],'')
	End

--------------------------------
If Update([mMelliCode])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير کد ملي ',d.[mMelliCode],i.[mMelliCode], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mMelliCode],'') <> IsNull(d.[mMelliCode],'')
	End

--------------------------------
If Update([mCreditCard_Price])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير مبلغ پرداختي با کارت ',d.[mCreditCard_Price],i.[mCreditCard_Price], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mCreditCard_Price],-1) <> IsNull(d.[mCreditCard_Price],-1)
	End

--------------------------------
If Update([mLiquidated])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت تسويه شده ',d.[mLiquidated],i.[mLiquidated], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mLiquidated],0) <> IsNull(d.[mLiquidated],0)
	End

--------------------------------
If Update([mESigned])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت امضاي الکترونيک ',d.[mESigned],i.[mESigned], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mESigned],0) <> IsNull(d.[mESigned],0)
	End

--------------------------------
If Update([mResponseDelivered])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت تحويل جواب به بيمار ',IsNull(d.[mResponseDelivered],0),IsNull(i.[mResponseDelivered],0), i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mResponseDelivered],0) <> IsNull(d.[mResponseDelivered],0)
	End

--------------------------------
If Update([mPatCode])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير کد پاتولوژي ',d.[mPatCode],i.[mPatCode], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mPatCode],-1) <> IsNull(d.[mPatCode],-1)
	End

--------------------------------
If Update([mCytCode])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير کد سيتولوژي ',d.[mCytCode],i.[mCytCode], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mCytCode],-1) <> IsNull(d.[mCytCode],-1)
	End

--------------------------------
If Update([mVerified])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت تاييد مسئول فني ',d.[mVerified],i.[mVerified], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mVerified],0) <> IsNull(d.[mVerified],0)
	End

--------------------------------
If Update([mDiscount])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير تخفيف ',d.[mDiscount],i.[mDiscount], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mDiscount],-1) <> IsNull(d.[mDiscount],-1)
	End

--------------------------------
If Update([mExtraMoney])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير مبلغ اضافي ',d.[mExtraMoney],i.[mExtraMoney], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mExtraMoney] ,-1) <> IsNull(d.[mExtraMoney],-1)
	End

--------------------------------
If Update([mLackSamplse])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير نمونه هاي ناقص ',d.[mLackSamplse],i.[mLackSamplse], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mLackSamplse] ,'') <> IsNull(d.[mLackSamplse],'')
	End

--------------------------------
If Update([mEmergency])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت اورژانس ',d.[mEmergency],i.[mEmergency], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mEmergency] ,0) <> IsNull(d.[mEmergency],0)
	End

--------------------------------
If Update([mSpecialkhadamat])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'تغيير وضعيت بیماران خاص ',d.[mSpecialkhadamat],i.[mSpecialkhadamat], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mSpecialkhadamat] ,0) <> IsNull(d.[mSpecialkhadamat],0)
	End
--------------------------------
If Update([mOnlineRecNoTakmili])
	Begin
		Insert Into [dbo].[tblUsersTrace]
				([mUserName],[mTime],[mDate],[mTask],[mOldValue],[mNewValue],[mRecID],[mRefid])
		Select
				@UserAction,@TimeReg,@DateReg, 'ثبت بیمه تکمیلی با مبلغ: (' + [dbo].[Format](i.[mInsure2Portion],3) + ') با کد رهگیری: ' + i.[mOnlineRecNoTakmili],d.[mOnlineRecNoTakmili],i.[mOnlineRecNoTakmili], i.[mNumber], i.[mNumber]
			From Inserted As i
			Left Join Deleted d On d.[mNumber] = i.[mNumber]
			Where	IsNull(i.[mOnlineRecNoTakmili] ,0) <> IsNull(d.[mOnlineRecNoTakmili],0)
	End



------ Ditas ++ -------------------------------------

Update
	[dbo].[Ditas_AdmissionType]
		Set
			[CountUse] +=1
	From Inserted As s
	Where	[dbo].[Ditas_AdmissionType].[AdmissionTypeCoding] = s.[DitasAdmissionType]

Update
	[dbo].[Ditas_CountriesIso]
		Set
			[CountUse] +=1
	From Inserted As s
	Where	[dbo].[Ditas_CountriesIso].[CountryCoding] = s.[DitasCountriesIso]

Update
	[dbo].[Ditas_EducationLevel]
		Set
			[CountUse] +=1
	From Inserted As s
	Where	[dbo].[Ditas_EducationLevel].[EducationLevelCoding] = s.[DitasEducationLevel]

Update
	[dbo].[Ditas_ReasonForEncounter]
		Set
			[CountUse] +=1
	From Inserted As s
	Where	[dbo].[Ditas_ReasonForEncounter].[ReasonCoding] = s.[DitasReasonForEncounter]
------ Ditas -- -------------------------------------

Update
	[dbo].[Ditas_AdmissionType]
		Set
			[CountUse] -=1
	From Deleted As s
	Where	[dbo].[Ditas_AdmissionType].[AdmissionTypeCoding] = s.[DitasAdmissionType]

Update
	[dbo].[Ditas_CountriesIso]
		Set
			[CountUse] -=1
	From Deleted As s
	Where	[dbo].[Ditas_CountriesIso].[CountryCoding] = s.[DitasCountriesIso]

Update
	[dbo].[Ditas_EducationLevel]
		Set
			[CountUse] -=1
	From Deleted As s
	Where	[dbo].[Ditas_EducationLevel].[EducationLevelCoding] = s.[DitasEducationLevel]

Update
	[dbo].[Ditas_ReasonForEncounter]
		Set
			[CountUse] -=1
	From Deleted As s
	Where	[dbo].[Ditas_ReasonForEncounter].[ReasonCoding] = s.[DitasReasonForEncounter]

--------------------------------------------------


----------------------------- End Update -----------------------
	

End;